DROP PROCEDURE [hips].[PatientMasterUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 19 October 2012
-- Description:   Updates an existing record in the Patient Master  Table
-- Modified: 18/12/2012 sbiber removed PcehrAdvertised
-- Modified: 16/06/2013 pstall01 added date of death indicator
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterUpdate] 
(
    @PatientMasterId INT,
	@CurrentSexId INT,
	@DeathIndicatorId INT = null,
	@DateOfBirth DATETIME,
	@DateOfDeath DATETIME = null,
	@MedicareNumber VARCHAR(12) = null,
	@MedicareIrn VARCHAR(3) = null,
	@IsMedicareNumberValid INT = null,
	@DvaNumber VARCHAR(18) = NULL,	 
	@StatePatientId VARCHAR(64) = NULL, 
	@UserModified VARCHAR(256),
	@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON

	IF (@MedicareIrn = '0') 
	BEGIN
		SET @MedicareIrn = NULL
	END  

	DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[PatientMaster]
				WHERE [PatientMasterId] = @PatientMasterId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[PatientMaster]
           SET [CurrentSexId] = @CurrentSexId
			  ,[DeathIndicatorId] = @DeathIndicatorId 
			  ,[DateOfBirth] = @DateOfBirth
			  ,[DateOfDeath] = @DateOfDeath
			  ,[MedicareNumber] = @MedicareNumber
			  ,[MedicareIrn] = @MedicareIrn
			  ,[IsMedicareNumberValid] = @IsMedicareNumberValid
			  ,[DvaNumber] = @DvaNumber
			  ,[StatePatientId] = @StatePatientId
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [PatientMasterID] = @PatientMasterID
        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT pm.[PatientMasterID]
			 , COALESCE (pmi.RegisteredSexId,pm.CurrentSexId, -1) AS RegisteredSexId
			 , COALESCE (pm.CurrentSexId, -1) AS CurrentSexId
			 , pmi.Ihi
			 , COALESCE (pmi.IhiStatusId, -1) AS IhiStatusId
			 , ihis.Description AS IhiStatus
			 , COALESCE (pmi.IhiRecordStatusId, -1) AS IhiRecordStatusId
			 , pmi.[RegisteredFamilyName]
			 , pmi.[RegisteredGivenName]
			 , irs.Description AS IhiRecordStatus
			 , pmi.DateLastValidated AS IhiLastValidated
			 , pm.[MedicareNumber]
			 , pm.[MedicareIrn]
			 , pm.[IsMedicareNumberValid]
			 , pm.[DvaNumber]
			 , pm.[StatePatientId]
			 , pm.[DateOfBirth]
			 , pm.[DateOfDeath]
			 , pm.[DeathIndicatorId]
			 , pm.[DateCreated]
			 , pm.[UserCreated]
			 , pm.[DateModified]
			 , pm.[UserModified]         
	     FROM	[hips].[PatientMaster] AS pm
         LEFT JOIN [hips].[PatientMasterIhi] AS pmi ON pmi.[PatientMasterID] = pm.[PatientMasterID]
         LEFT JOIN [hips].IhiRecordStatus AS irs on irs.IhiRecordStatusId = pmi.IhiRecordStatusId
		 LEFT JOIN [hips].IhiStatus AS ihis on ihis.IhiStatusId = pmi.IhiStatusId

        WHERE	pm.[PatientMasterID] = @PatientMasterID
    END

    RETURN(@intErrorCode)

END
GO

